﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;
using Microsoft.Reporting.WinForms;


namespace gov.va.med.vbecs.GUI
{
    /// <summary>
    /// Class DlgExportReport
    /// </summary>
    public class DlgExportReport : gov.va.med.vbecs.GUI.VbecsBaseForm
    {
        private System.Windows.Forms.Button btnCancel;
        private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
        private System.Windows.Forms.GroupBox grpComment;
        private System.Windows.Forms.Label lblMessage;
        private System.Windows.Forms.TextBox txtFileName;
        private Label lblExtension;
        private Label label1;
        private Label lblExportDir;
        private System.ComponentModel.IContainer components = null;

        /// <summary>
        /// Constructor
        /// </summary>
        public DlgExportReport()
        {
            // This call is required by the Windows Form Designer.
            InitializeComponent();
            //
            this.btnOK.EnabledButton = false;

            //maximum length of the file name including file path and file extension is 255
            this.txtFileName.MaxLength = 255 - Common.VbecsConfig.Current.ReportExportPath.Length - 4;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="title"></param>
        /// <param name="message"></param>
        /// <param name="cannnedCommentContext"></param>
        public DlgExportReport(string title, string message, string cannnedCommentContext)
            : this()
        {
            this.Message = message;
            this.Title = title;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="title"></param>
        /// <param name="message"></param>
        /// <param name="cannedCommentContext"></param>
        /// <param name="helpFile"></param>
        public DlgExportReport(string title, string message, string cannedCommentContext, string helpFile)
            : this(title, message, cannedCommentContext)
        {
            this.hlphelpChm.SetHelpKeyword(this, helpFile);
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.hlphelpChm.SetShowHelp(this, true);
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpComment = new System.Windows.Forms.GroupBox();
            this.lblExportDir = new System.Windows.Forms.Label();
            this.lblExtension = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.lblMessage = new System.Windows.Forms.Label();
            this.txtFileName = new System.Windows.Forms.TextBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpComment.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(646, 30);
            this.vbecsLogo1.TabIndex = 3;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 142);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(568, 129);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(488, 129);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // grpComment
            // 
            this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComment.AutoSize = true;
            this.grpComment.Controls.Add(this.lblExportDir);
            this.grpComment.Controls.Add(this.lblExtension);
            this.grpComment.Controls.Add(this.label1);
            this.grpComment.Controls.Add(this.lblMessage);
            this.grpComment.Controls.Add(this.txtFileName);
            this.grpComment.Location = new System.Drawing.Point(2, 28);
            this.grpComment.Name = "grpComment";
            this.grpComment.Size = new System.Drawing.Size(635, 97);
            this.grpComment.TabIndex = 0;
            this.grpComment.TabStop = false;
            // 
            // lblExportDir
            // 
            this.lblExportDir.AutoSize = true;
            this.lblExportDir.Location = new System.Drawing.Point(6, 65);
            this.lblExportDir.Name = "lblExportDir";
            this.lblExportDir.Size = new System.Drawing.Size(81, 14);
            this.lblExportDir.TabIndex = 6;
            this.lblExportDir.Text = "Directory Name";
            // 
            // lblExtension
            // 
            this.lblExtension.AutoSize = true;
            this.lblExtension.Location = new System.Drawing.Point(604, 36);
            this.lblExtension.Name = "lblExtension";
            this.lblExtension.Size = new System.Drawing.Size(25, 14);
            this.lblExtension.TabIndex = 5;
            this.lblExtension.Text = ".ext";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(6, 35);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(57, 14);
            this.label1.TabIndex = 4;
            this.label1.Text = "File Name*";
            // 
            // lblMessage
            // 
            this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblMessage.Location = new System.Drawing.Point(8, 12);
            this.lblMessage.Name = "lblMessage";
            this.lblMessage.Size = new System.Drawing.Size(619, 18);
            this.lblMessage.TabIndex = 0;
            this.lblMessage.Text = "Enter a file name for the report";
            this.lblMessage.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // txtFileName
            // 
            this.txtFileName.AccessibleDescription = "Details";
            this.txtFileName.AccessibleName = "Details";
            this.txtFileName.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtFileName.Location = new System.Drawing.Point(67, 33);
            this.txtFileName.MaxLength = 255;
            this.txtFileName.Name = "txtFileName";
            this.txtFileName.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtFileName.Size = new System.Drawing.Size(528, 20);
            this.txtFileName.TabIndex = 3;
            this.txtFileName.TextChanged += new System.EventHandler(this.txtFileName_TextChanged);
            this.txtFileName.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtFileName_KeyPress);
            // 
            // DlgExportReport
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.AutoSize = true;
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(646, 156);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpComment);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "DlgExportReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Export Report";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgExportReport_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.DlgExportReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpComment, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpComment.ResumeLayout(false);
            this.grpComment.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// Get/Set Message
        /// </summary>
        public string Message
        {
            get
            {
                return this.lblMessage.Text;
            }
            set
            {
                this.lblMessage.Text = value;
            }
        }

        /// <summary>
        /// Get/Set Title
        /// </summary>
        public string Title
        {
            get
            {
                return this.vbecsLogo1.Title;
            }
            set
            {
                this.vbecsLogo1.Title = value;
                this.Text = "VBECS - " + value;
            }
        }
        /// <summary>
        /// String for the path that reports get exported to
        /// </summary>
        public string ExportDir
        {
            set { this.lblExportDir.Text = "Export Directory: " + value; }
            
        }

        /// <summary>
        /// Returns text from the FileName text box
        /// </summary>
        public string FileName
        {
            get
            {
                return this.txtFileName.Text;
            }
        }

        /// <summary>
        /// Extension
        /// </summary>
        public string Extension
        {
            set { this.lblExtension.Text = value; }
            get { return this.lblExtension.Text; }
        }

        /// <summary>
        /// btnOK_MouseHover
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnOK_MouseHover(object sender, System.EventArgs e)
        {
            if (this.btnOK.EnabledButton)
            {
                this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
            }
            else
            {
                this.btnOK.SetToolTip("Enter file name.");
            }
        }

        /// <summary>
        /// DlgExportReport_Load
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DlgExportReport_Load(object sender, System.EventArgs e)
        {
            Common.Utility.MessageBeep();
        }

        /// <summary>
        /// txtFileName_TextChanged
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void txtFileName_TextChanged(object sender, EventArgs e)
        {
            btnOK.EnabledButton = (this.txtFileName.Text.Trim().Length > 0);
        }

        /// <summary>
        /// Filtering out characters that are not allowed in the file name
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void txtFileName_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\\' || e.KeyChar == '/' || e.KeyChar == '?' || e.KeyChar == '%' || e.KeyChar == '*' || e.KeyChar == '|' || e.KeyChar == ':' ||
                e.KeyChar == '\'' || e.KeyChar == '"' || e.KeyChar == '<' || e.KeyChar == '>' || e.KeyChar == '.')
            {
                e.Handled = true;
            }
        }


        /// <summary>
        /// **** 508 Compliance ***
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DlgExportReport_KeyDownSpeakMessage(object sender, EventArgs e)
        {
            string textToSpeak = string.Empty;
            //
            if (!this.btnOK.EnabledButton)
            {
                    textToSpeak = "Enter File Name";
            }
            //
            this.SpeakMessage(textToSpeak);
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            string fileNameWithPath;

            if (Common.VbecsConfig.Current.ReportExportPath.EndsWith("\\"))
                fileNameWithPath = Common.VbecsConfig.Current.ReportExportPath;
            else
                fileNameWithPath = Common.VbecsConfig.Current.ReportExportPath + "\\";
            fileNameWithPath = fileNameWithPath + this.FileName + this.Extension;

            if (System.IO.File.Exists(fileNameWithPath))
            {
                if (MessageBox.Show("The report file with this name already exists. Would you like to overwrite it?", "File Already Exists", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
                {
                    this.DialogResult = DialogResult.OK;
                }
                else
                {
                    return;
                }
            }
            else
            {
                this.DialogResult = DialogResult.OK;
            }
        }
    }
}

